// This is a samle program on C/C++ language.
// Demonstrate OOP
// Description of Matrix class.
// I used this class for my own graduate work, and temp paper.
#ifndef __matrix_h__
#define __matrix_h__
#include <iostream.h>
#include <stdlib.h>
#include <math.h>
//  
#define debug
class CMatrixException{
	char ne;// ne='a'    .
			// ne='+'   
			// ne='-'   
			// ne='*'   
			// ne='/' Division isn't possble
			// ne='d'    double  
			// ne='='   
			// ne='0' Zero division matrix/double
			// ne='i' Index out of range
public:
	CMatrixException(char c){ne=c;}
	void PrintMessage(){
		cout<<"\tERROR! >>> ";
		switch(ne){
		case 'a':cout<<"Can't allocate memory"<<endl;break;
		case '+':cout<<"Addition isn't possible"<<endl;break;
		case '-':cout<<"Substruction isn't possible"<<endl;break;
		case '*':cout<<"Multiplication isn't possible"<<endl;break;
		case '/':cout<<"Division isn't possble"<<endl;break;
		case 'd':cout<<"Conversion to double isn't possible"<<endl;break;
		case '=':cout<<"Can't give to matrix"<<endl;break;
		case '0':cout<<"Zero division matrix/double"<<endl;break;
		case 'i':cout<<"Index out of range"<<endl;break;
		case 'T':cout<<"Transporent isn't possible"<<endl;break;
		case 'I':cout<<"Invertation isn't possible"<<endl;break;
		default	:cout<<"Unknown error"<<endl;
		}
	}
};
class Matrix {
	int rows, cols;
	
public:
	double* p;
	//
	Matrix(int, int);
	Matrix(int, int,double,...);
	Matrix(int, int,   int,...);
	Matrix(double);
			//     1  1, m(0,0)=i
	Matrix(int);
			//     1  1, m(0,0)=i
	Matrix(Matrix const &);
	//
	~Matrix(){if(p!=NULL)delete[]p;}
	//
	Matrix const& operator=(Matrix const&);
	//   double
	operator double()const;
	// 
	friend double operator+(double,Matrix const&);
	double operator+(double d){return d+*this;}
	double operator+(   int i){return double(i)+*this;}
	friend double operator+( int i,Matrix const&m){return double(i)+m;}
	Matrix const& operator+()const{return*this;}//unary +
	Matrix  operator+(Matrix const&)const;//binary +
	Matrix& operator+=(Matrix const&a){*this=*this+a;return*this;}

	// 
	friend double operator-(double,Matrix const&);
	double operator-(double d)const{return -(d-*this);}
	double operator-(   int i)const{return *this-double(i);}
	friend double operator-(int i,Matrix const&m){return -(m-i);}
	Matrix  operator-(Matrix const&)const;//binary -
	Matrix& operator-=(Matrix const&a){*this=*this-a;return*this;}
	Matrix  operator-()const;//unary -
	// 
	Matrix& Matrix::operator*=(Matrix const&a){*this=(*this)*a;return*this;}
	Matrix  operator*(double)const;
	friend Matrix operator*(double d,Matrix const&a){return a*d;}
	Matrix& operator*=(double d){*this=*this*d;return*this;}
	Matrix operator*(Matrix const&)const;
	//Division operators
	Matrix  operator/(double d)const{
		if(d==0)throw CMatrixException('d');
		return (1./d)*(*this);
	}
	Matrix& operator/=(double d){*this=*this/d;return*this;}
	//Transposition operator
	Matrix  operator*()const;
//	friend Matrix T(Matrix const&a){return *a;}
	//   
	double& Matrix::operator()(int i, int j)const;
	// 
	Matrix T(Matrix const&a)const;
	// 
	Matrix Inv(Matrix const&a)const;
	//   
	void Print()const;
	// -    
	int GetRows()const{return rows;}
	int GetCols()const{return cols;}
};
void Print(Matrix const&);
#endif
